<?php 
session_start();
require_once 'config/auth_check.php';
require_once 'config/db.php';

// Fetch companies for the selective list
$companies = $conn->query("SELECT id, company_name FROM company ORDER BY company_name ASC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin - Add Category</title>
    <link rel="stylesheet" href="assets/css/admin.css">
    <style>
        .selective-box {
            display: none; /* Hidden by default */
            margin-top: 15px;
            padding: 15px;
            background: #f0f7ff;
            border: 1px dashed #3498db;
            border-radius: 8px;
        }
        .company-list {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 10px;
            max-height: 200px;
            overflow-y: auto;
            margin-top: 10px;
        }

        .alert { padding: 15px; margin-bottom: 20px; border-radius: 4px; text-align: center; }
    .success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
    .error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
    </style>
</head>
<body>

<?php include 'side-bar.php' ?>

<div class="main">
    <h2>Create New Category</h2>

    <div id="msg" class="alert"></div>

    <form id="addCategoryForm">
        <label>Category Name</label>
        <input type="text" name="category_name" placeholder="e.g. Business Cards, Social Media" required>

        <label>Status</label>
        <select name="status">
            <option value="Active">Active</option>
            <option value="Not Active">Not Active</option>
        </select>

        <label>Visibility / Permissions</label>
        <select name="companies_allowed" id="permissionSelect" onchange="toggleCompanyList()">
            <option value="For All">For All Companies</option>
            <option value="For Selective Companies">For Selective Companies</option>
        </select>

        <div id="selectiveBox" class="selective-box">
            <label>Select Allowed Companies:</label>
            <div class="company-list">
                <?php while($row = $companies->fetch_assoc()): ?>
                    <label style="font-weight: normal; cursor:pointer;">
                        <input type="checkbox" name="allowed_companies[]" value="<?php echo $row['id']; ?>"> 
                        <?php echo $row['company_name']; ?>
                    </label>
                <?php endwhile; ?>
            </div>
        </div>

        <button type="submit" style="margin-top: 20px; background: #3498db;">Save Category</button>
    </form>
</div>

<script>
// Show/Hide logic for the company list
function toggleCompanyList() {
    const select = document.getElementById('permissionSelect');
    const box = document.getElementById('selectiveBox');
    box.style.display = (select.value === 'For Selective Companies') ? 'block' : 'none';
}

// AJAX Submission
document.getElementById('addCategoryForm').addEventListener('submit', async (e) => {
    e.preventDefault();
    const formData = new FormData(e.target);
    const msg = document.getElementById('msg');

    try {
        const res = await fetch("api/save-categories.php", {
            method: "POST",
            body: formData
        });
        const data = await res.json();

        msg.style.display = "block";
        msg.className = "alert " + (data.success ? "alert-success" : "alert-error");
        msg.innerText = data.message;

        if (data.success) {
            e.target.reset();
            toggleCompanyList();
        }
    } catch (err) {
        console.error(err);
    }
});
</script>

</body>
</html>