<?php session_start(); require_once 'config/auth_check.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin - Add Upliner</title>
  <link rel="stylesheet" href="assets/css/admin.css">
  <style>
    .photo-grid {
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      gap: 15px;
      margin-bottom: 20px;
    }
    .photo-box {
      border: 2px dashed #cbd5e0;
      border-radius: 10px;
      padding: 15px;
      text-align: center;
      background: #f8fafc;
      transition: border-color 0.3s;
    }
    .photo-box:hover { border-color: #3498db; }
    .photo-box img {
      width: 100%;
      height: 120px;
      object-fit: cover;
      display: none;
      margin-top: 10px;
      border-radius: 5px;
    }
    .alert { padding: 15px; margin-bottom: 20px; border-radius: 4px; text-align: center; }
    .success { background-color: #d4edda; color: #155724; }
    .error { background-color: #f8d7da; color: #721c24; }
    label { display: block; margin-bottom: 8px; font-weight: 600; color: #4a5568; }
  </style>
</head>
<body>

<?php include 'side-bar.php' ?>

<div class="main">
  <h2>Register New Upliner</h2>

  <?php if (isset($_SESSION['msg'])): ?>
    <div class="alert <?php echo $_SESSION['msg_type']; ?>">
      <?php echo $_SESSION['msg']; unset($_SESSION['msg']); unset($_SESSION['msg_type']); ?>
    </div>
  <?php endif; ?>

  <form action="api/save-upliner.php" method="POST" enctype="multipart/form-data">
    
    <label>Upliner Full Name</label>
    <input name="upliner_name" placeholder="Enter Full Name" required>

    <div class="row">
        <div style="flex:1">
            <label>Uploaded By</label>
            <select name="uploaded_by" required>
                <option value="Admin" selected>Admin</option>
                <option value="User">User</option>
            </select>
        </div>
        <div style="flex:1">
            <label>Initial Status</label>
            <select name="status" required>
                <option value="pending">Pending</option>
                <option value="active" selected>Active</option>
                <option value="inactive">Inactive</option>
            </select>
        </div>
    </div>

    <label>Upliner Photos (Select 3)</label>
    <div class="photo-grid">
      <div class="photo-box">
        <span>Photo 1</span>
        <input type="file" name="photo_1" id="p1" accept="image/*" required>
        <img id="prev1" src="#">
      </div>
      <div class="photo-box">
        <span>Photo 2</span>
        <input type="file" name="photo_2" id="p2" accept="image/*">
        <img id="prev2" src="#">
      </div>
      <div class="photo-box">
        <span>Photo 3</span>
        <input type="file" name="photo_3" id="p3" accept="image/*">
        <img id="prev3" src="#">
      </div>
    </div>

    <button type="submit" style="background: #3498db; width: 100%; padding: 12px; font-size: 16px;">
        Register Upliner
    </button>
  </form>
</div>

<script>
  function setupPreview(inputId, imgId) {
    document.getElementById(inputId).onchange = evt => {
      const [file] = document.getElementById(inputId).files;
      if (file) {
        const preview = document.getElementById(imgId);
        preview.src = URL.createObjectURL(file);
        preview.style.display = 'block';
      }
    }
  }
  setupPreview('p1', 'prev1');
  setupPreview('p2', 'prev2');
  setupPreview('p3', 'prev3');
</script>

</body>
</html>