<?php
session_start();
require_once '../config/db.php'; // Ensure path to your database connection is correct

if (isset($_GET['id'])) {
    $id = intval($_GET['id']);

    // 1. Prepare the delete statement to prevent SQL injection
    $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
    $stmt->bind_param("i", $id);

    // 2. Execute and set a session message for feedback
    if ($stmt->execute()) {
        $_SESSION['msg'] = "User account has been permanently deleted.";
        $_SESSION['msg_type'] = "success";
    } else {
        $_SESSION['msg'] = "Error: Could not delete user. " . $conn->error;
        $_SESSION['msg_type'] = "error";
    }

    $stmt->close();
}

// 3. Redirect back to the modern user list page
header("Location: ../manage-users.php");
exit();