<?php
header("Content-Type: application/json");
require "../config/db.php";

$price = intval($_POST['price']);
$status = $_POST['status'];

$file_db_path = "";
if (!empty($_FILES["effect_file"]["name"])) {
    $dir = "../uploads/effects/";
    if (!is_dir($dir)) mkdir($dir, 0777, true);

    $ext = pathinfo($_FILES["effect_file"]["name"], PATHINFO_EXTENSION);
    $filename = "effect_" . time() . "_" . bin2hex(random_bytes(2)) . "." . $ext;
    
    if (move_uploaded_file($_FILES["effect_file"]["tmp_name"], $dir . $filename)) {
        $file_db_path = "uploads/effects/" . $filename;
    }
}

$sql = "INSERT INTO effects (file_location, price, status) VALUES (?, ?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("sis", $file_db_path, $price, $status); // "sis" -> String, Integer, String

if ($stmt->execute()) {
    echo json_encode(["success" => true, "message" => "Effect saved successfully!"]);
} else {
    echo json_encode(["success" => false, "message" => "Database error: " . $conn->error]);
}