<?php 
session_start();
require_once 'config/auth_check.php';
require_once 'config/db.php';

// Fetch Companies for dropdown
$companies = $conn->query("SELECT id, company_name, company_code FROM company");

// Fetch All Upliners for checkboxes
$upliners = $conn->query("SELECT id, upliner_name, upliner_code, photo_1 FROM upliners WHERE status='active'");
?>
<!DOCTYPE html>
<html>
<head>
  <title>Admin - Assign Upliners</title>
  <link rel="stylesheet" href="assets/css/admin.css">
  <style>
    .assign-container { background: #fff; padding: 25px; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
    .upliner-selection-grid { 
        display: grid; 
        grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); 
        gap: 15px; 
        margin-top: 20px; 
        max-height: 400px; 
        overflow-y: auto;
        padding: 10px;
        border: 1px solid #eee;
    }
    .upliner-item {
        display: flex;
        align-items: center;
        gap: 10px;
        padding: 10px;
        border: 1px solid #f0f0f0;
        border-radius: 8px;
        cursor: pointer;
        transition: 0.2s;
    }
    .upliner-item:hover { background: #f8fbff; border-color: #3498db; }
    .upliner-item input { transform: scale(1.2); }
    .u-thumb { width: 40px; height: 40px; border-radius: 50%; object-fit: cover; }
    .company-select { width: 100%; padding: 12px; margin-bottom: 20px; font-size: 16px; border-radius: 8px; border: 1px solid #ddd; }

    .alert { padding: 15px; margin-bottom: 20px; border-radius: 4px; text-align: center; }
    .success { background-color: #12812eff; color: #ffffffff; }
    .error { background-color: #ff0017; color: #ffffffff; }
    label { display: block; margin-bottom: 8px; font-weight: 600; color: #4a5568; }
  </style>
</head>
<body>

<div class="sidebar">
  <h3>Admin</h3>
  <a href="manage-companies.php">Companies</a>
  <a href="manage-upliners.php">Upliners</a>
  <a class="active" href="assign-upliners.php">Assign Links</a>
</div>

<div class="main">
  <h2>Assign Upliners to Company</h2>
  
  <?php if (isset($_SESSION['msg'])): ?>
    <div class="alert <?php echo $_SESSION['msg_type']; ?>">
      <?php echo $_SESSION['msg']; unset($_SESSION['msg']); ?>
    </div>
  <?php endif; ?>

  <div class="assign-container">
    <form action="api/save-assignments.php" method="POST">
      
      <label>Step 1: Select Company</label>
      <select name="company_id" class="company-select" required>
        <option value="">-- Choose Company --</option>
        <?php while($c = $companies->fetch_assoc()): ?>
          <option value="<?php echo $c['id']; ?>">
            <?php echo $c['company_name']; ?> (<?php echo $c['company_code']; ?>)
          </option>
        <?php endwhile; ?>
      </select>

      <label>Step 2: Select Upliners to Link</label>
      <div class="upliner-selection-grid">
        <?php while($u = $upliners->fetch_assoc()): ?>
          <label class="upliner-item">
            <input type="checkbox" name="upliner_ids[]" value="<?php echo $u['id']; ?>">
            <img src="<?php echo !empty($u['photo_1']) ? $u['photo_1'] : 'assets/img/default.png'; ?>" class="u-thumb">
            <div>
                <strong><?php echo $u['upliner_name']; ?></strong><br>
                <small style="color:#7f8c8d"><?php echo $u['upliner_code']; ?></small>
            </div>
          </label>
        <?php endwhile; ?>
      </div>

      <button type="submit" style="margin-top: 25px; background: #3498db; width: 100%; padding: 15px;">
        Save Assignments
      </button>
    </form>
  </div>
</div>

</body>
</html>