<?php 
session_start();
require_once 'config/auth_check.php';
require_once 'config/db.php';

if (!isset($_GET['id'])) { header("Location: manage-companies.php"); exit; }

$id = intval($_GET['id']);
// Fetch Company Data
$res = $conn->query("SELECT * FROM company WHERE id = $id");
$data = $res->fetch_assoc();

if (!$data) { die("Company not found."); }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Company | Grovia Admin</title>
    <style>
        :root { --sidebar-bg: #3b4368; --accent: #3498db; --bg: #f4f7f6; }
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background: var(--bg); display: flex; }
        
        /* Sidebar */
        .sidebar { width: 280px; background: var(--sidebar-bg); height: 100vh; position: fixed; color: #fff; }
        .logo-area { padding: 30px; text-align: center; border-bottom: 1px solid rgba(255,255,255,0.1); }
        .menu-link { display: block; padding: 18px 25px; color: #fff; text-decoration: none; border-bottom: 1px solid rgba(255,255,255,0.1); }
        
        .main-content { margin-left: 280px; width: 100%; padding: 40px; }
        .edit-card { background: #fff; padding: 35px; border-radius: 12px; box-shadow: 0 10px 30px rgba(0,0,0,0.05); max-width: 800px; margin: auto; }
        
        .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px; }
        label { display: block; margin-bottom: 8px; font-weight: 600; color: #444; font-size: 13px; text-transform: uppercase; }
        input[type="text"] { width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 6px; box-sizing: border-box; }
        
        .logo-preview-box { border: 1px solid #eee; padding: 15px; border-radius: 8px; text-align: center; background: #fafafa; }
        .logo-preview-box img { max-width: 100px; height: 60px; object-fit: contain; margin-bottom: 10px; display: block; margin-left: auto; margin-right: auto; }
        
        .btn-update { background: var(--accent); color: #fff; border: none; padding: 15px; border-radius: 6px; cursor: pointer; font-weight: bold; width: 100%; margin-top: 20px; }
        .alert { padding: 15px; border-radius: 6px; margin-bottom: 20px; display: none; }
        .alert-success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
    </style>
</head>
<body>
<?php include 'top-bar.php'; ?>
<div class="sidebar">
    <div class="logo-area"><h2>GROVIA</h2></div>
    <a href="manage-companies.php" class="menu-link">← Back to Companies</a>
</div>

<div class="main-content">
    <div class="edit-card">
        <h2 style="margin-top:0;">Edit Company: <?php echo htmlspecialchars($data['company_name']); ?></h2>
        <div id="msg" class="alert alert-success"></div>

        <form id="editCompanyForm" enctype="multipart/form-data">
            <input type="hidden" name="id" value="<?php echo $data['id']; ?>">
            
            <div class="form-row">
                <div>
                    <label>Company Name</label>
                    <input type="text" name="company_name" value="<?php echo htmlspecialchars($data['company_name']); ?>" required>
                </div>
                <div>
                    <label>Company Code</label>
                    <input type="text" name="company_code" value="<?php echo htmlspecialchars($data['company_code']); ?>" disabled>
                </div>
            </div>

            <div class="form-row">
                <div class="logo-preview-box">
                    <label>Left Logo</label>
                    <img src="<?php echo $data['left_logo']; ?>" id="prev_left" onerror="this.src='assets/img/placeholder.png'">
                    <input type="file" name="left_logo" onchange="previewFile(this, 'prev_left')">
                </div>
                <div class="logo-preview-box">
                    <label>Right Logo</label>
                    <img src="<?php echo $data['right_logo']; ?>" id="prev_right" onerror="this.src='assets/img/placeholder.png'">
                    <input type="file" name="right_logo" onchange="previewFile(this, 'prev_right')">
                </div>
            </div>

            <button type="submit" class="btn-update">Save Company Changes</button>
        </form>
    </div>
</div>

<script>
function previewFile(input, imgId) {
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = (e) => { document.getElementById(imgId).src = e.target.result; };
        reader.readAsDataURL(input.files[0]);
    }
}

document.getElementById('editCompanyForm').onsubmit = async (e) => {
    e.preventDefault();
    const btn = e.target.querySelector('button');
    btn.innerText = "Updating...";
    btn.disabled = true;

    const res = await fetch('api/update-company.php', {
        method: 'POST',
        body: new FormData(e.target)
    });
    
    const result = await res.json();
    const msg = document.getElementById('msg');
    msg.style.display = "block";
    msg.innerText = result.message;
    
    if(result.success) {
        setTimeout(() => { window.location.href = 'manage-companies.php'; }, 1500);
    } else {
        btn.innerText = "Save Company Changes";
        btn.disabled = false;
    }
};
</script>
</body>
</html>