<?php 
session_start();
require_once 'config/auth_check.php';
require_once 'config/db.php';

// 1. Capture and Validate ID
if (!isset($_GET['id'])) {
    header("Location: manage-upliners.php");
    exit();
}

$id = $conn->real_escape_string($_GET['id']);
$res = $conn->query("SELECT * FROM upliners WHERE id = '$id'");
$data = $res->fetch_assoc();

if (!$data) {
    die("Upliner record not found.");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Upliner | Grovia Admin</title>
    <style>
        :root {
            --sidebar-bg: #3b4368;        /* Deep Navy-Purple from image */
            --accent: #3498db;
            --bg-body: #f4f7f6;
            --border-muted: rgba(255, 255, 255, 0.1);
        }

        body { margin: 0; font-family: 'Segoe UI', sans-serif; background: var(--bg-body); display: flex; }

        /* --- Sidebar & Top Bar --- */
        .sidebar { width: 280px; background: var(--sidebar-bg); height: 100vh; position: fixed; color: #fff; }
        .logo-area { padding: 30px; text-align: center; border-bottom: 1px solid var(--border-muted); }
        .menu-link { display: flex; justify-content: space-between; padding: 18px 25px; color: #fff; text-decoration: none; border-bottom: 1px solid var(--border-muted); font-size: 16px; transition: 0.3s; }
        .menu-link:hover { background: #4a537d; }
        .chevron { width: 8px; height: 8px; border-top: 2px solid #fff; border-right: 2px solid #fff; transform: rotate(45deg); opacity: 0.6; }

        /* --- Main Content Layout --- */
        .main-content { margin-left: 280px; width: 100%; padding: 40px; }
        .edit-card { background: #fff; padding: 40px; border-radius: 12px; box-shadow: 0 10px 30px rgba(0,0,0,0.05); max-width: 900px; margin: auto; }
        
        .form-header { display: flex; justify-content: space-between; align-items: center; border-bottom: 1px solid #eee; padding-bottom: 20px; margin-bottom: 30px; }
        .form-header h2 { margin: 0; color: #333; }
        .upliner-badge { background: #e1f5fe; color: #0288d1; padding: 5px 12px; border-radius: 4px; font-weight: bold; font-family: monospace; }

        /* --- Form Elements --- */
        .form-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px; }
        label { display: block; margin-bottom: 8px; font-weight: 600; color: #666; font-size: 13px; text-transform: uppercase; }
        input, select { width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 6px; box-sizing: border-box; font-size: 14px; }
        input[readonly] { background: #f9f9f9; color: #888; border: 1px solid #eee; }

        /* --- Photo Management Grid --- */
        .photo-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px; margin-top: 15px; }
        .photo-box { background: #fafafa; border: 1px solid #eee; padding: 15px; border-radius: 10px; text-align: center; }
        .img-container { width: 100%; height: 120px; border-radius: 6px; overflow: hidden; background: #eee; margin-bottom: 10px; border: 1px solid #ddd; position: relative; }
        .img-container img { width: 100%; height: 100%; object-fit: cover; }
        .no-photo-msg { position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); color: #999; font-size: 11px; font-weight: bold; }
        
        .file-input-wrapper { position: relative; overflow: hidden; display: inline-block; width: 100%; }
        .file-input-wrapper input[type=file] { position: absolute; left: 0; top: 0; opacity: 0; cursor: pointer; height: 100%; width: 100%; }
        .btn-upload { background: #fff; border: 1px solid var(--accent); color: var(--accent); padding: 8px; border-radius: 4px; font-size: 12px; font-weight: bold; display: block; cursor: pointer; transition: 0.2s; }
        .btn-upload:hover { background: var(--accent); color: #fff; }

        .btn-submit { background: #2ecc71; color: #fff; border: none; padding: 15px 30px; border-radius: 6px; cursor: pointer; font-weight: bold; width: 100%; margin-top: 30px; font-size: 16px; transition: 0.3s; }
        .btn-submit:hover { background: #27ae60; transform: translateY(-2px); }
    </style>
</head>
<body>

<?php include 'top-bar.php'; ?>
<div class="sidebar">
    <div class="logo-area"><h2>GROVIA</h2></div>
    <a href="manage-upliners.php" class="menu-link">← Back to Upliners</a>
</div>

<div class="main-content">
    <div class="edit-card">
        <div class="form-header">
            <h2>Edit Upliner Profile</h2>
            <span class="upliner-badge"><?php echo htmlspecialchars($data['upliner_code']); ?></span>
        </div>

        <form action="api/update-upliner.php" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="id" value="<?php echo $data['id']; ?>">

            <div class="form-grid">
                <div style="grid-column: span 2;">
                    <label>Full Name</label>
                    <input name="upliner_name" value="<?php echo htmlspecialchars($data['upliner_name']); ?>" required>
                </div>
                <div>
                    <label>Account Status</label>
                    <select name="status">
                        <option value="active" <?php echo ($data['status'] == 'active') ? 'selected' : ''; ?>>Active</option>
                        <option value="pending" <?php echo ($data['status'] == 'pending') ? 'selected' : ''; ?>>Pending</option>
                        <option value="inactive" <?php echo ($data['status'] == 'inactive') ? 'selected' : ''; ?>>Inactive</option>
                    </select>
                </div>
                <div>
                    <label>Record Uploaded By</label>
                    <input value="<?php echo htmlspecialchars($data['uploaded_by']); ?>" readonly>
                </div>
            </div>

            <h3 style="margin-top: 40px; font-size: 14px; text-transform: uppercase; color: #888; border-bottom: 1px solid #eee; padding-bottom: 10px;">Visual Assets Management</h3>
            
            <div class="photo-grid">
                <?php for($i=1; $i<=3; $i++): 
                    $photo_path = $data['photo_'.$i];
                ?>
                <div class="photo-box">
                    <label>Photo <?php echo $i; ?></label>
                    <div class="img-container" id="prev_container_<?php echo $i; ?>">
                        <?php if(!empty($photo_path)): ?>
                            <img src="<?php echo $photo_path; ?>" id="img_<?php echo $i; ?>">
                        <?php else: ?>
                            <div class="no-photo-msg" id="msg_<?php echo $i; ?>">No Image Uploaded</div>
                            <img src="" id="img_<?php echo $i; ?>" style="display:none;">
                        <?php endif; ?>
                    </div>
                    
                    <div class="file-input-wrapper">
                        <span class="btn-upload">Choose New Photo</span>
                        <input type="file" name="photo_<?php echo $i; ?>" accept="image/*" onchange="previewImage(this, <?php echo $i; ?>)">
                    </div>
                </div>
                <?php endfor; ?>
            </div>

            <button type="submit" class="btn-submit">Update Upliner Profile</button>
        </form>
    </div>
</div>

<script>
// Logic to handle instant image preview when a new file is selected
function previewImage(input, index) {
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const img = document.getElementById('img_' + index);
            const msg = document.getElementById('msg_' + index);
            
            img.src = e.target.result;
            img.style.display = 'block';
            if (msg) msg.style.display = 'none';
        }
        reader.readAsDataURL(input.files[0]);
    }
}
</script>

</body>
</html>