<?php 
session_start();
require_once 'config/db.php';

if(isset($_SESSION['team_id'])) {
    header("Location: dashboard.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Grovia | Staff Login</title>
    <style>
        :root { --navy: #3b4368; --accent: #3498db; --error: #e74c3c; }
        
        body { 
            margin: 0; padding: 0; font-family: 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #1e2440 0%, #3b4368 100%);
            height: 100vh; display: flex; align-items: center; justify-content: center;
        }

        .login-card {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            padding: 40px; border-radius: 20px; width: 100%; max-width: 400px;
            box-shadow: 0 20px 50px rgba(0,0,0,0.3); border: 1px solid rgba(255,255,255,0.1);
            text-align: center;
        }

        /* Logo Styling */
        .brand-logo { 
            width: 180px; /* Adjust based on your logo aspect ratio */
            height: auto;
            margin-bottom: 20px;
            filter: drop-shadow(0 5px 15px rgba(0,0,0,0.2));
        }

        .subtitle { color: rgba(255,255,255,0.6); font-size: 14px; margin-bottom: 30px; letter-spacing: 1px; }

        .form-group { text-align: left; margin-bottom: 20px; }
        label { display: block; color: #fff; font-size: 11px; font-weight: 600; margin-bottom: 8px; text-transform: uppercase; opacity: 0.8; }
        
        input {
            width: 100%; padding: 12px 15px; border-radius: 8px; border: 1px solid rgba(255,255,255,0.2);
            background: rgba(255,255,255,0.1); color: #fff; font-size: 15px; box-sizing: border-box;
            outline: none; transition: 0.3s;
        }
        input:focus { border-color: var(--accent); background: rgba(255,255,255,0.15); box-shadow: 0 0 10px rgba(52, 152, 219, 0.3); }

        .btn-login {
            width: 100%; padding: 14px; border: none; border-radius: 8px;
            background: var(--accent); color: #fff; font-size: 16px; font-weight: 700;
            cursor: pointer; transition: 0.3s; margin-top: 10px;
        }
        .btn-login:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(52, 152, 219, 0.4); }

        #error-box { 
            background: rgba(231, 76, 60, 0.2); color: #ff8a80; padding: 12px; 
            border-radius: 8px; font-size: 13px; margin-bottom: 20px; display: none;
            border: 1px solid rgba(231, 76, 60, 0.3);
        }
    </style>
</head>
<body>

<div class="login-card">
    <img src="assets/img/logo.png" alt="Grovia Logo" class="brand-logo">
    <div class="subtitle">STAFF PORTAL</div>

    <div id="error-box"></div>

    <form id="loginForm">
        <div class="form-group">
            <label>Username</label>
            <input type="text" name="user_name" placeholder="Enter username" required autocomplete="username">
        </div>
        
        <div class="form-group">
            <label>Password</label>
            <input type="password" name="password" placeholder="••••••••" required autocomplete="current-password">
        </div>

        <button type="submit" class="btn-login" id="loginBtn">Authorize Access</button>
    </form>
</div>

<script>
document.getElementById('loginForm').onsubmit = async (e) => {
    e.preventDefault();
    const btn = document.getElementById('loginBtn');
    const errorBox = document.getElementById('error-box');
    
    btn.innerText = "Verifying...";
    btn.disabled = true;
    errorBox.style.display = "none";

    try {
        const res = await fetch('api/auth-team.php', {
            method: 'POST',
            body: new FormData(e.target)
        });
        const data = await res.json();

        if(data.success) {
            window.location.href = "dashboard.php";
        } else {
            errorBox.innerText = data.message;
            errorBox.style.display = "block";
            btn.innerText = "Authorize Access";
            btn.disabled = false;
        }
    } catch (err) {
        errorBox.innerText = "Server unreachable. Please try again.";
        errorBox.style.display = "block";
        btn.disabled = false;
        btn.innerText = "Authorize Access";
    }
};
</script>

</body>
</html>