<?php 
session_start();
require_once 'config/auth_check.php';
require_once 'config/db.php';

$current_date = date('Y-m-d');

// Fetch all banners
$query = "SELECT * FROM banners ORDER BY id DESC";
$result = $conn->query($query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin - Manage Banners</title>
  <link rel="stylesheet" href="assets/css/admin.css">
  <style>
    .banner-table {
        width: 100%;
        border-collapse: collapse;
        background: #fff;
        border-radius: 8px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.05);
    }
    .banner-table th, .banner-table td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #eee;
    }
    .banner-thumb {
        width: 180px;
        height: 60px;
        object-fit: cover;
        border-radius: 5px;
        border: 1px solid #ddd;
    }
    .status-active { color: #2ecc71; font-weight: bold; }
    .status-expired { color: #e74c3c; font-weight: bold; }
    .status-pending { color: #f39c12; font-weight: bold; }
    
    .path-text {
        font-family: monospace;
        font-size: 11px;
        background: #f4f4f4;
        padding: 4px 8px;
        border-radius: 4px;
        color: #666;
    }
  </style>
</head>
<body>

<?php include 'side-bar.php' ?>

<div class="main">
  <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
    <h2>Banner Management</h2>
    <a href="add-banner.php" class="btn-view" style="text-decoration:none; background:#3498db; color:#fff; padding:8px 15px; border-radius:5px;">+ New Banner</a>
  </div>

  <table class="banner-table">
    <thead>
      <tr>
        <th>Banner ID</th>
        <th>Preview</th>
        <th>Target Directory</th>
        <th>Schedule</th>
        <th>Status</th>
        <th>Action</th>
      </tr>
    </thead>
    <tbody>
      <?php if ($result->num_rows > 0): ?>
        <?php while($row = $result->fetch_assoc()): 
            // Logic to determine real-time status
            $is_expired = (strtotime($row['end_date']) < strtotime($current_date));
            $is_pending = (strtotime($row['start_date']) > strtotime($current_date));
        ?>
          <tr>
            <td><strong><?php echo $row['banner_id']; ?></strong></td>
            <td>
              <img src="<?php echo $row['banner_image']; ?>" class="banner-thumb">
            </td>
            <td>
              <span class="path-text"><?php echo $row['target_url']; ?></span>
            </td>
            <td>
              <small>
                From: <?php echo date('d M, Y', strtotime($row['start_date'])); ?><br>
                To: <?php echo date('d M, Y', strtotime($row['end_date'])); ?>
              </small>
            </td>
            <td>
              <?php if($row['status'] == 'Not Active'): ?>
                <span style="color:#95a5a6;">Disabled</span>
              <?php elseif($is_expired): ?>
                <span class="status-expired">Expired</span>
              <?php elseif($is_pending): ?>
                <span class="status-pending">Scheduled</span>
              <?php else: ?>
                <span class="status-active">Live</span>
              <?php endif; ?>
            </td>
            <td>
              <!-- <a href="edit-banner.php?id=<?php echo $row['id']; ?>" style="color:#3498db; text-decoration:none;">Edit</a> | -->
              <a href="api/delete-banner.php?id=<?php echo $row['id']; ?>" style="color:#e74c3c; text-decoration:none;" onclick="return confirm('Delete this banner permanently?');">Delete</a>
            </td>
          </tr>
        <?php endwhile; ?>
      <?php else: ?>
        <tr><td colspan="6" style="text-align:center; padding: 40px; color:#999;">No banners found.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>

</body>
</html>