<?php 
session_start();
require_once 'config/auth_check.php';
include 'config/db.php'; 

// Fetch all companies sorted by newest first
$query = "SELECT * FROM company ORDER BY id DESC";
$result = $conn->query($query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Companies | Grovia Admin</title>
    <style>
        :root {
            --sidebar-bg: #3b4368;
            --topbar-bg: #ffffff;
            --bg-body: #f4f7f6;
            --accent: #3498db;
            --border-color: rgba(255, 255, 255, 0.1);
        }

        body { margin: 0; font-family: 'Segoe UI', sans-serif; background: var(--bg-body); display: flex; }

        /* --- Sidebar (Matching Side_bar_menu_list.png) --- */
        .sidebar { width: 280px; background: var(--sidebar-bg); height: 100vh; position: fixed; color: #fff; }
        .logo-area { padding: 30px; text-align: center; border-bottom: 1px solid var(--border-color); }
        .menu-item { border-bottom: 1px solid var(--border-color); transition: 0.3s; }
        .menu-link { display: flex; justify-content: space-between; padding: 18px 25px; color: #fff; text-decoration: none; font-size: 16px; }
        .menu-item:hover, .menu-item.active { background: #4a537d; }
        .chevron { width: 8px; height: 8px; border-top: 2px solid #fff; border-right: 2px solid #fff; transform: rotate(45deg); opacity: 0.6; }

        /* --- Main Content Area --- */
        .main-content { margin-left: 280px; width: 100%; }
        .top-bar { height: 70px; background: #fff; display: flex; justify-content: flex-end; align-items: center; padding: 0 30px; box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
        .container { padding: 30px; }

        /* --- Modern Table Styling --- */
        .company-card { background: #fff; border-radius: 10px; box-shadow: 0 4px 15px rgba(0,0,0,0.05); overflow: hidden; }
        .modern-table { width: 100%; border-collapse: collapse; }
        .modern-table th { background: #f8f9fa; padding: 15px; text-align: left; color: #636e72; font-size: 12px; text-transform: uppercase; letter-spacing: 1px; }
        .modern-table td { padding: 15px; border-top: 1px solid #eee; font-size: 14px; vertical-align: middle; }
        
        /* Logo Previews */
        .logo-thumb {
            width: 45px; height: 45px; object-fit: contain; border: 1px solid #eee; border-radius: 6px; background: #fff; padding: 3px;
        }

        .badge-code {
            background: #e1f5fe; color: #0288d1; padding: 4px 10px; border-radius: 4px; font-weight: bold; font-size: 12px;
        }

        /* Action Buttons */
        .btn-add { background: #2ecc71; color: #fff; padding: 10px 20px; border-radius: 5px; text-decoration: none; font-weight: bold; font-size: 14px; }
        .btn-edit { color: var(--accent); text-decoration: none; font-weight: 600; margin-right: 10px; }
        .btn-delete { color: #e74c3c; text-decoration: none; font-weight: 600; }
    </style>
</head>
<body>

<?php include 'side-bar.php'; ?>

<div class="main-content">
    
    <div class="container">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 25px;">
            <div>
                <h2 style="margin:0;">Registered Companies</h2>
                <p id="msg"></p>
                <p style="color: #888; margin: 5px 0 0 0;">Network entities and organizational branding</p>
            </div>
            <a href="add-company.php" class="btn-add">+ Register Company</a>
        </div>

        <div class="company-card">
            <table class="modern-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Identifier</th>
                        <th>Company Name</th>
                        <th>Logo (L)</th>
                        <th>Logo (R)</th>
                        <th>Registration</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result->num_rows > 0): ?>
                        <?php while($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><span style="color:#aaa;">#<?php echo $row['id']; ?></span></td>
                            <td><span class="badge-code"><?php echo $row['company_code']; ?></span></td>
                            <td><strong><?php echo htmlspecialchars($row['company_name']); ?></strong></td>
                            <td><img src="<?php echo $row['left_logo']; ?>" class="logo-thumb" onerror="this.src='assets/img/placeholder.png'"></td>
                            <td><img src="<?php echo $row['right_logo']; ?>" class="logo-thumb" onerror="this.src='assets/img/placeholder.png'"></td>
                            <td>
                                <div style="font-size:13px;"><?php echo date('d M Y', strtotime($row['created_at'])); ?></div>
                                <div style="font-size:11px; color:#bbb;">Official Record</div>
                            </td>
                            <td>
                                <a href="edit-company.php?id=<?php echo $row['id']; ?>" class="btn-edit">Edit</a>
                                <a href="api/delete-company.php?id=<?php echo $row['id']; ?>" 
                                   class="btn-delete" 
                                   onclick="return confirm('Permanently delete this company and its associations?');">Delete</a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="7" style="text-align:center; padding: 50px; color: #999;">
                                No companies found in the network.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
const res = await fetch('api/delete-company.php', {
        method: 'POST',
        body: new FormData(e.target)
    });
    
    const result = await res.json();
    const msg = document.getElementById('msg');
    msg.style.display = "block";
    msg.innerText = result.message;
</script>

</body>
</html>