<?php 
session_start();
require_once 'config/auth_check.php';
require_once 'config/db.php';

$query = "SELECT * FROM effects ORDER BY id DESC";
$result = $conn->query($query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin - Manage Effects</title>
  <link rel="stylesheet" href="assets/css/admin.css">
  <style>
    .effect-table {
        width: 100%;
        border-collapse: collapse;
        background: #fff;
        border-radius: 8px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.05);
    }
    .effect-table th, .effect-table td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #eee;
    }
    .effect-thumb {
        width: 60px;
        height: 60px;
        object-fit: contain;
        background: #000000ff;
        border-radius: 4px;
        border: 1px solid #ddd;
    }
    .price-tag {
        font-weight: bold;
        color: #2c3e50;
    }
    .free-tag {
        color: #27ae60;
        font-weight: bold;
    }
  </style>
</head>
<body>

<?php include 'side-bar.php' ?>

<div class="main">
  <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
    <h2>Graphic Effects</h2>
    <a href="add-effect.php" class="btn-view" style="text-decoration:none; background:#9b59b6; color:#fff; padding:8px 15px; border-radius:5px;">+ Add New Effect</a>
  </div>

  <table class="effect-table">
    <thead>
      <tr>
        <th>Effect ID</th>
        <th>Preview</th>
        <th>Price</th>
        <th>Status</th>
        <th>Action</th>
      </tr>
    </thead>
    <tbody>
      <?php if ($result->num_rows > 0): ?>
        <?php while($row = $result->fetch_assoc()): ?>
          <tr>
            <td><code><?php echo $row['effect_id']; ?></code></td>
            <td>
              <img src="<?php echo $row['file_location']; ?>" class="effect-thumb">
            </td>
            <td>
              <?php if($row['price'] <= 0): ?>
                <span class="free-tag">Free</span>
              <?php else: ?>
                <span class="price-tag">₹<?php echo (int)$row['price']; ?></span>
              <?php endif; ?>
            </td>
            <td>
                <span style="color: <?php echo ($row['status'] == 'Active') ? '#2ecc71' : '#e74c3c'; ?>; font-weight:bold;">
                    <?php echo $row['status']; ?>
                </span>
            </td>
            <td>
              <!-- <a href="edit-effect.php?id=<?php echo $row['id']; ?>" style="color:#3498db; text-decoration:none;">Edit</a> | -->
              <a href="api/delete-effect.php?id=<?php echo $row['id']; ?>" style="color:#e74c3c; text-decoration:none;" onclick="return confirm('Delete this effect?');">Delete</a>
            </td>
          </tr>
        <?php endwhile; ?>
      <?php else: ?>
        <tr><td colspan="5" style="text-align:center; padding: 40px; color:#999;">No effects found.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>

</body>
</html>