<?php 
session_start();
require_once 'config/auth_check.php';
require_once 'config/db.php';

// Fetch all tracks sorted by latest
$query = "SELECT * FROM musics ORDER BY id DESC";
$result = $conn->query($query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Music | Grovia Admin</title>
    <style>
        :root { --sidebar-bg: #3b4368; --accent: #3498db; --bg: #f4f7f6; }
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background: var(--bg); display: flex; }

        /* Sidebar */
        .sidebar { width: 280px; background: var(--sidebar-bg); height: 100vh; position: fixed; color: #fff; }
        .logo-area { padding: 30px; text-align: center; border-bottom: 1px solid rgba(255,255,255,0.1); }
        .menu-link { display: block; padding: 18px 25px; color: #fff; text-decoration: none; border-bottom: 1px solid rgba(255,255,255,0.1); }
        .menu-link:hover, .active { background: #4a537d; }

        .main-content { margin-left: 280px; width: 100%; padding: 40px; }
        
        /* Modern Table Card */
        .music-card { background: #fff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); overflow: hidden; }
        .music-table { width: 100%; border-collapse: collapse; }
        .music-table th { background: #f8f9fa; padding: 15px; text-align: left; color: #636e72; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; }
        .music-table td { padding: 15px; border-top: 1px solid #eee; font-size: 14px; vertical-align: middle; }

        /* Audio Player Styling */
        audio { height: 35px; width: 210px; outline: none; }
        
        .status-badge { padding: 5px 12px; border-radius: 20px; font-size: 11px; font-weight: bold; }
        .status-active { background: #e8f5e9; color: #2e7d32; }
        .status-inactive { background: #ffebee; color: #c62828; }

        .btn-add { background: #2ecc71; color: #fff; padding: 10px 20px; border-radius: 6px; text-decoration: none; font-weight: bold; float: right; }
    </style>
</head>
<body>

<?php include ('side-bar.php')?>

<div class="main-content">
    <div style="margin-bottom: 30px; overflow: hidden;">
        <h2 style="float: left; margin: 0;">Audio Library</h2>
        <a href="add-music.php" class="btn-add">+ Upload Music</a>
    </div>

    <div id="responseOverlay" style="display:none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); z-index: 9999; align-items: center; justify-content: center;">
    <div style="background: white; padding: 40px; border-radius: 15px; text-align: center; max-width: 400px; width: 90%; box-shadow: 0 10px 30px rgba(0,0,0,0.2);">
        <div id="statusIcon" style="font-size: 50px; margin-bottom: 20px;"></div>
        <h3 id="statusTitle" style="margin: 0 0 10px 0; color: #333;"></h3>
        <p id="statusDesc" style="color: #666; margin-bottom: 20px;"></p>
        <div style="font-size: 12px; color: #aaa;">Redirecting in <span id="timer">3</span> seconds...</div>
    </div>
</div>

    <div class="music-card">
        <table class="music-table">
            <thead>
                <tr>
                    <th>Music ID</th>
                    <th>Name </th>
                    <th>Preview</th>
                    <th>Length</th>
                    <th>Added On</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($result->num_rows > 0): ?>
                    <?php while($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td style="font-weight:bold; color:var(--accent);"><?php echo $row['music_id']; ?></td>
                        <td style="font-weight:bold; color:var(--accent);"><?php echo $row['music_title']; ?></td>
                        <td>
                            <audio controls>
                                <source src="<?php echo $row['file_location']; ?>" type="audio/mpeg">
                                Your browser does not support the audio element.
                            </audio>
                        </td>
                        <td><span style="color:#666;"><?php echo $row['music_length']; ?></span></td>
                        <td><?php echo date('d M Y', strtotime($row['created_at'])); ?></td>
                        <td>
                            <span class="status-badge <?php echo ($row['status'] == 'Active') ? 'status-active' : 'status-inactive'; ?>">
                                <?php echo $row['status']; ?>
                            </span>
                        </td>
                        <td>
                            <!-- <a href="edit-music.php?id=<?php echo $row['id']; ?>" style="color:var(--accent); text-decoration:none; font-weight:600;">Edit</a> | -->
                            <a href="javascript:void(0)" onclick="deleteMusic(<?php echo $row['id']; ?>, this)" style="color:#e74c3c; text-decoration:none; font-weight:600;">Delete</a>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="6" style="text-align:center; padding:50px; color:#999;">No audio tracks found in the library.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
async function deleteMusic(id, element) {
    if (!confirm("Are you sure? This will permanently delete the audio file from the server.")) return;

    // Visual feedback: Dim the row while processing
    const row = element.closest('tr');
    row.style.opacity = '0.5';

    try {
        const response = await fetch(`api/delete-music.php?id=${id}`);
        const data = await response.json();

        if (data.success) {
            // Smoothly remove the row
            row.style.transition = 'all 0.5s ease';
            row.style.transform = 'translateX(20px)';
            row.style.opacity = '0';
            setTimeout(() => row.remove(), 500);
            
            // Show success toast (if you have the toast function from previous steps)
            if (typeof showToast === "function") showToast(data.message, "success");
        } else {
            row.style.opacity = '1';
            alert(data.message);
        }
    } catch (error) {
        row.style.opacity = '1';
        alert("System error: Could not reach the server.");
    }
}


</script>



</body>
</html>