<?php 
session_start();
require_once 'config/auth_check.php';
require_once 'config/db.php';

// Fetch team members
$query = "SELECT * FROM team_grovia ORDER BY id DESC";
$result = $conn->query($query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Team Management | Grovia Admin</title>
    <style>
        :root { --sidebar-bg: #3b4368; --accent: #3498db; --bg: #f4f7f6; }
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background: var(--bg); display: flex; }
        .sidebar { width: 280px; background: var(--sidebar-bg); height: 100vh; position: fixed; color: #fff; }
        .main-content { margin-left: 280px; width: 100%; padding: 40px; }
        
        .team-card { background: #fff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); overflow: hidden; }
        .team-table { width: 100%; border-collapse: collapse; }
        .team-table th { background: #f8f9fa; padding: 15px; text-align: left; color: #636e72; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; }
        .team-table td { padding: 15px; border-top: 1px solid #eee; font-size: 14px; }

        .role-badge { padding: 4px 10px; border-radius: 4px; font-size: 11px; font-weight: bold; }
        .role-Admin { background: #fee2e2; color: #dc2626; }
        .role-Moderator { background: #fef3c7; color: #d97706; }
        .role-Support { background: #dcfce7; color: #16a34a; }
        .role-Editor { background: #e0f2fe; color: #0284c7; }

        .btn-add { background: var(--accent); color: #fff; padding: 10px 20px; border-radius: 6px; text-decoration: none; font-weight: bold; float: right; }

        /* Toast Alert Styling */
        #toast {
            position: fixed; top: 20px; right: 20px; padding: 15px 25px; 
            background: #333; color: #fff; border-radius: 8px; font-size: 14px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2); display: none; z-index: 10000;
        }
        .toast-success { border-left: 5px solid #2ecc71; }
        .toast-error { border-left: 5px solid #e74c3c; }
    </style>
</head>
<body>

<?php include_once 'side-bar.php'; ?>

<div id="toast"></div>  

<div class="main-content">
    <div style="margin-bottom: 30px; overflow: hidden;">
        <h2 style="float: left; margin: 0;">Grovia Team Members</h2>
        <a href="add-team-member.php" class="btn-add">+ Add Staff</a>
    </div>

    <div class="team-card">
        <table class="team-table">
            <thead>
                <tr>
                    <th>Emp ID</th>
                    <th>User Name</th>
                    <th>Role</th>
                    <th>Mobile</th>
                    <th>Joined Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($result->num_rows > 0): ?>
                    <?php while($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td style="font-weight:bold; color:var(--accent);"><?php echo $row['emp_id']; ?></td>
                        <td><strong><?php echo htmlspecialchars($row['user_name']); ?></strong></td>
                        <td><span class="role-badge role-<?php echo $row['role']; ?>"><?php echo $row['role']; ?></span></td>
                        <td><?php echo $row['mobile_number'] ?? 'N/A'; ?></td>
                        <td><?php echo date('d M Y', strtotime($row['created_at'])); ?></td>
                        <td>
                            <a href="edit-team.php?id=<?php echo $row['id']; ?>" style="color:var(--accent); text-decoration:none;">Edit   | </a>
                            <a href="javascript:void(0)" onclick="deleteStaff(<?php echo $row['id']; ?>, this)" style="color:#e74c3c; text-decoration:none; font-weight:600;">Delete</a>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="6" style="text-align:center; padding:40px; color:#999;">No team members found.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>


<script>
// Function to show the alert message
function showToast(message, type = 'success') {
    const toast = document.getElementById('toast');
    toast.innerText = message;
    toast.className = (type === 'success') ? 'toast-success' : 'toast-error';
    toast.style.display = 'block';
    
    // Hide after 4 seconds
    setTimeout(() => {
        toast.style.display = 'none';
    }, 4000);
}

async function deleteStaff(id, element) {
    if (!confirm("Confirm Deletion: This team member will lose all administrative access immediately.")) return;

    const row = element.closest('tr');
    row.style.opacity = '0.5';

    try {
        const response = await fetch(`api/delete-team-member.php?id=${id}`);
        const data = await response.json();

        if (data.success) {
            // Animate row removal
            row.style.transition = 'all 0.5s ease';
            row.style.transform = 'translateX(20px)';
            row.style.opacity = '0';
            
            setTimeout(() => {
                row.remove();
                showToast(data.message, 'success');
            }, 500);
        } else {
            row.style.opacity = '1';
            showToast(data.message, 'error');
        }
    } catch (error) {
        row.style.opacity = '1';
        showToast("System Error: Could not reach the server.", 'error');
    }
}
</script>

</body>
</html>