<?php 
session_start();
require_once 'config/auth_check.php';
require_once 'config/db.php';

// Search and Filter logic
$search = isset($_GET['search']) ? $conn->real_escape_string($_GET['search']) : '';
$where = "WHERE 1=1";
if ($search != '') {
    $where .= " AND (name LIKE '%$search%' OR email LIKE '%$search%' OR mobile LIKE '%$search%')";
}

$query = "SELECT u.*, u.rank AS user_rank, c.company_name
          FROM users u 
          LEFT JOIN company c ON u.company = c.id
          $where 
          ORDER BY u.id DESC";

$result = $conn->query($query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Users | Grovia Admin</title>
    <style>
        :root {
            --sidebar-bg: #3b4368;
            --topbar-bg: #ffffff;
            --bg-body: #f4f7f6;
            --text-dark: #2d3436;
            --accent: #3498db;
        }

        body { margin: 0; font-family: 'Segoe UI', sans-serif; background: var(--bg-body); display: flex; }

        /* Sidebar Styling (Matching your menu list image) */
        .sidebar { width: 280px; background: var(--sidebar-bg); height: 100vh; position: fixed; color: #fff; }
        .logo-area { padding: 30px; text-align: center; border-bottom: 1px solid rgba(255,255,255,0.1); }
        .menu-item { border-bottom: 1px solid rgba(255,255,255,0.1); transition: 0.3s; }
        .menu-link { display: flex; justify-content: space-between; padding: 18px 25px; color: #fff; text-decoration: none; }
        .menu-item:hover, .menu-item.active { background: #4a537d; }

        /* Main Content & Top Bar */
        .main-content { margin-left: 280px; width: 100%; }
        .top-bar { height: 70px; background: #fff; display: flex; justify-content: flex-end; align-items: center; padding: 0 30px; box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
        .container { padding: 30px; }

        /* Table Styling */
        .user-card { background: #fff; border-radius: 10px; box-shadow: 0 4px 15px rgba(0,0,0,0.05); overflow: hidden; }
        .user-table { width: 100%; border-collapse: collapse; }
        .user-table th { background: #f8f9fa; padding: 15px; text-align: left; color: #636e72; font-size: 13px; text-transform: uppercase; }
        .user-table td { padding: 15px; border-top: 1px solid #eee; font-size: 14px; vertical-align: middle; }
        
        /* Rank Badges */
        .rank_badge { padding: 4px 10px; border-radius: 20px; font-size: 11px; font-weight: bold; }
        .rank-manager { background: #e3f2fd; color: #1976d2; }
        .rank-associate { background: #f3e5f5; color: #7b1fa2; }
        
        .user-info { display: flex; align-items: center; gap: 10px; }
        .avatar { width: 35px; height: 35px; border-radius: 50%; background: #eee; display: flex; align-items: center; justify-content: center; font-weight: bold; color: var(--sidebar-bg); }
        
        .btn-add { background: #2ecc71; color: #fff; padding: 10px 20px; border-radius: 5px; text-decoration: none; font-weight: bold; height: 25px; width: 100px; text-align: center;}
        .search-input { padding: 10px; width: 300px; border: 1px solid #ddd; border-radius: 5px; }
    </style>
</head>
<body>

<?php include 'side-bar.php' ?> 

<div class="main-content">
    <div class="container">
        <div style="display: flex; justify-content: space-between; margin-bottom: 25px;">
            <h2>User Management</h2>
            <a href="add-user.php" class="btn-add">+ New User</a>
        </div>

        <form method="GET" style="margin-bottom: 20px;">
            <input type="text" name="search" class="search-input" placeholder="Search by name, email, or mobile..." value="<?php echo htmlspecialchars($search); ?>">
            <button type="submit" style="padding:10px 20px; background:var(--accent); color:#fff; border:none; border-radius:5px; cursor:pointer;">Search</button>
        </form>

        <div class="user-card">
            <table class="user-table">
                <thead>
                    <tr>
                        <th>User Details</th>
                        <th>Contact</th>
                        <th>Gender</th>
                        <th>Rank</th>
                        <th>Company ID</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($user = $result->fetch_assoc()): ?>
                    <tr>
                        <td>
                            <div class="user-info">
                                <div class="avatar"><?php echo substr($user['name'], 0, 1); ?></div>
                                <div>
                                    <div style="font-weight:bold;"><?php echo $user['name']; ?></div>
                                    <div style="font-size:12px; color:#999;">Joined: <?php echo date('d M Y', strtotime($user['created_at'])); ?></div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div><?php echo $user['email']; ?></div>
                            <div style="font-size:12px; color:#666;"><?php echo $user['mobile']; ?></div>
                        </td>
                        <td><?php echo $user['gender']; ?></td>
                        <td>
                            <?php 
                                  $current_rank = $user['user_rank'] ?? 'No Rank'; 
                                  $badge_class = (strtolower($current_rank) == 'manager') ? 'rank-manager' : 'rank-associate';
                              ?>
                              <span class="rank_badge <?php echo $badge_class; ?>">
                                  <?php echo htmlspecialchars($current_rank); ?>
                              </span>
                        </td>
                        <td><div class="company-tag"><?php echo htmlspecialchars($user['company_name'] ?? 'No Company Assigned'); ?></div>
                            <div style="font-size:11px; color:#aaa;">Company_ID: #<?php echo $user['company']; ?></div></td>
                        <td>
                            <a href="edit-user.php?id=<?php echo $user['id']; ?>" style="color:var(--accent); text-decoration:none;">Edit</a> | 
                            <a href="api/delete-user.php?id=<?php echo $user['id']; ?>" style="color:#e74c3c; text-decoration:none;" onclick="return confirm('Delete user?')">Delete</a>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
</div>

</body>
</html>