const menu = document.querySelector('#mobile-menu');

menu.addEventListener('click', function() {
  // Toggle a class to animate the bars or open a side menu
  this.classList.toggle('is-active');
  
  // Example: simple alert to show it works
  console.log("Menu clicked!");
});

// Menu Appear Code

const menuBtn = document.getElementById('mobile-menu'); // Your navbar hamburger
const sidebar = document.getElementById('sidebar');
const overlay = document.getElementById('overlay');

// Function to open menu
menuBtn.addEventListener('click', () => {
  sidebar.classList.add('active');
  overlay.classList.add('active');
});

// Function to close menu (clicking the overlay)
overlay.addEventListener('click', () => {
  sidebar.classList.remove('active');
  overlay.classList.remove('active');
});

// Optional: Close menu when a link inside is clicked
const menuLinks = document.querySelectorAll('.sidebar-menu li');
menuLinks.forEach(link => {
  link.addEventListener('click', () => {
    sidebar.classList.remove('active');
    overlay.classList.remove('active');
  });
});

// Banner JS Settings

const slider = document.querySelector('.slider-container');
let isScrolling = false;

function autoScroll() {
  if (isScrolling) return;
  const cardWidth = slider.querySelector('.slider-card').offsetWidth + 20;
  
  if (slider.scrollLeft + slider.offsetWidth >= slider.scrollWidth) {
    slider.scrollTo({ left: 0, behavior: 'smooth' });
  } else {
    slider.scrollBy({ left: cardWidth, behavior: 'smooth' });
  }
}

// Auto scroll every 3 seconds
setInterval(autoScroll, 3000);

// Pause auto-scroll when user interacts
slider.addEventListener('mousedown', () => isScrolling = true);
slider.addEventListener('mouseup', () => isScrolling = false);


// Detect Text
function initSmartMarquee() {
  const badges = document.querySelectorAll('.marquee-box');
  
  badges.forEach(box => {
    const text = box.innerText;
    // If text is long, wrap it in a span and animate
    if (text.length > 12) {
      box.innerHTML = `<span class="marquee-active">${text}</span>`;
    }
  });
}

// Call this after page loads
window.addEventListener('DOMContentLoaded', initSmartMarquee);